import * as d3 from 'd3';

const createLineChart = async (eventBus) => {
    const svgWidth = 800;
    const svgHeight = 400;
    const paddingLeft = 70;
    const paddingBottom = 20;
    const paddingRight = 10;
    const paddingTop = 10;
    const graphWidth = svgWidth - paddingLeft - paddingRight;
    const graphHeight = svgHeight - paddingTop - paddingBottom;

    const svg = d3.select("body")
        .append("svg")
        .attr("width", svgWidth)
        .attr("height", svgHeight);

    const graphsG = svg.append("g")
        .attr("transform", `translate(${paddingLeft}, ${paddingTop})`);

    /* TASK: Axes */
    /* enter code here */
    /* (see second part below) */

    /* TASK: Helper functions */
    /* replace const timeFormatter */
    const timeFormatter = d => d;
    const populationFormatter = d3.format(",");

    let countries = [];

    eventBus.countryClicked = async (countryLabel, color) => {
        const countryLowerCaseLabel = countryLabel.toLowerCase();

        const filteredCountries = countries.filter(country => {
            return country.label !== countryLabel
        });

        if (filteredCountries.length === countries.length) {
            let data;

            try {
                data = await d3.json(`./data/population_${countryLowerCaseLabel}.json`);
            } catch(e) {
                console.log("Sorry. No data available. Please test with Germany and Switzerland.");
                return;
            }

            data.forEach(d => {
                d.population = Number(d.population);
                d.date = d3.isoParse(d.date);
            });

            countries.push({
                label: countryLabel,
                color: color,
                data: data
            });
        } else {
            countries = filteredCountries;
        }

        //extent of extents
        //source: https://github.com/d3/d3-array/issues/64
        const countriesFlattened = countries.map(country => country.data).flat();
        const populationExtent = d3.extent(countriesFlattened,d => d.population);
        const temporalExtent = d3.extent(countriesFlattened, d => d.date);

        const scaleX = d3.scaleTime()
            .domain(temporalExtent)
            .range([0, graphWidth]);

        const scaleY = d3.scaleLinear()
            .domain(populationExtent)
            .range([graphHeight, 0]);

        /* TASK: Axes */
        /* enter code here */
        /* (see first part above) */

        const graph = graphsG.selectAll("g")
            .data(countries, country => country.label);

        const graphG = graph.enter().append("g").merge(graph);
        graph.exit().remove();

        /* TASK: Generator functions */
        /* replace const lineMaker */
        const lineMaker = data => {
            let d;
            if (countries.length === 1) {
                if (data.length === 36) //Germany
                    d = "M0,369.9385182908085L22.22598105548038,370L44.48240866035183,336.5539501998155L66.7083897158322,302.2471564709499L88.96481732070366,264.2514601905933L111.19079837618403,227.1165078389179L133.44722598105548,187.98339993851826L155.67320703653587,166.89517368582847L177.92963464140732,150.94067015063018L200.1556156968877,127.82354749462036L222.41204330175913,125.94835536427911L244.6380243572395,146.6369505072241L266.89445196211096,150.81770673224713L289.1204330175913,140.85766984322163L311.3768606224628,145.43805717798952L333.60284167794316,162.007377805103L355.85926928281464,159.82477712880416L378.085250338295,141.07285582539197L400.3416779431664,99.17307101137412L422.56765899864683,61.60774669535813L444.82408660351825,44.26990470335074L467.05006765899867,29.729480479557317L489.3064952638701,28.960959114663392L511.5324763193505,22.10574853980939L533.7889039242219,13.590531816784502L556.0148849797023,14.697202582231789L578.2713125845738,20.415001537042713L600.4972936400541,30.036889025514927L622.7537212449256,37.722102674454355L656.0926928281461,76.20965262834305L675.5175913396481,58.26928988625884L681.0588633288227,51.8505994466646L689.4316644113667,24.697202582231768L700.575101488498,14.06231171226562L700.605548037889,8.733476790654791L720,0";
                else if (data.length === 56) //Switzerland
                    d = "M0,370L12.657060518731988,357.44728967971986L25.279538904899137,340.99743482708186L37.90201729106628,326.7982180811232L50.524495677233425,315.59973424171255L63.18155619596542,307.6715080986173L75.80403458213256,300.4169760275828L88.4265129682997,291.7177863673009L101.04899135446685,282.7655782473337L113.70605187319885,274.6688696350444L126.328530259366,269.42339373970344L138.95100864553314,265.58897326165715L151.5734870317003,259.9818908351629L164.23054755043228,254.51228255778014L176.8530259365994,250.4967640582629L189.4755043227666,250.823707296244L202.0979827089337,255.08328367625924L214.7550432276657,257.5981409666081L227.37752161383287,257.5316440368493L240,256.0428909658115L252.62247838616713,253.09026222121668L265.27953890489914,249.00305908820056L277.9020172910663,244.61296479817986L290.5244956772334,241.37489444552432L303.1469740634006,238.6522932008578L315.80403458213254,235.2920760055956L328.4265129682997,231.31181031103912L341.04899135446686,226.47993588660978L353.671469740634,220.7876100554778L366.328530259366,214.47676845570217L378.9510086455332,206.387841399023L391.5734870317003,196.4299261676317L404.1959654178674,187.541739027911L416.85302593659947,180.12556282443063L429.4755043227666,173.57844489976705L442.09798270893367,168.04976754116225L454.72046109510086,164.37557636726902L467.37752161383287,162.36463375385173L480,159.87748351756903L492.6224783861672,155.86998237837733L505.24495677233426,151.12335135858567L517.9020172910663,145.7465322367352L530.5244956772334,139.27381069979828L543.1469740634005,132.87784359774264L555.7694524495678,126.90915464009507L568.4265129682997,121.30997167156865L581.0489913544668,115.78990118507802L593.671469740634,107.86886708580423L606.2939481268012,96.4844512282558L618.9510086455331,85.14743211851419L631.5734870317003,75.5881447586029L644.1959654178675,65.27298538329417L656.8184438040346,55.31459854247192L669.4755043227666,44.58383335617028L690.5014409221902,29.98457391043881L720,0";
            } else if (countries.length === 2) {
                if (data.length === 36) //Germany
                    d = "M0,57.34119774185802L22.22598105548038,57.350727527673634L44.48240866035183,52.166524043978015L66.7083897158322,46.848903558863746L88.96481732070366,40.95949592481248L111.19079837618403,35.20350529217983L133.44722598105548,29.13779662053962L155.67320703653587,25.869080085783L177.92963464140732,23.39610066663042L200.1556156968877,19.81290119995845L222.41204330175913,19.522242732582125L244.6380243572395,22.729015659537225L266.89445196211096,23.377041094999157L289.1204330175913,21.833215792869222L311.3768606224628,22.543184836132713L333.60284167794316,25.11146211344145L355.85926928281464,24.77315471698707L378.085250338295,21.866570043223906L400.3416779431664,15.372021009880921L422.56765899864683,9.549321876538981L444.82408660351825,6.861922276534971L467.05006765899867,4.608127931141586L489.3064952638701,4.489005608446356L511.5324763193505,3.4264344900050636L533.7889039242219,2.106559154542129L556.0148849797023,2.278095299223224L578.2713125845738,3.1643653800756155L600.4972936400541,4.655776860219644L622.7537212449256,5.847000087171779L656.0926928281461,11.812646007748018L675.5175913396481,9.031854506750964L681.0588633288227,8.036944867600573L689.4316644113667,3.828114962133352L700.575101488498,2.179685965998278L700.605548037889,1.3537060751083851L720,0";
                else if (data.length === 56) //Switzerland
                    d = "M66.7083897158322,370L77.85182679296346,369.49269614678434L88.96481732070366,368.82789352339404L100.07780784844385,368.25404794072085L111.19079837618403,367.80147364744425L122.3342354533153,367.4810631887516L133.44722598105548,367.18787932813416L144.56021650879566,366.8363112347173L155.67320703653587,366.4745176811203L166.8166441136671,366.1472981904624L177.92963464140732,365.93530810499396L189.0426251691475,365.78034425784625L200.1556156968877,365.55374024582954L211.29905277401892,365.3326920989434L222.41204330175913,365.1704093762893L233.52503382949934,365.18362242432266L244.6380243572395,365.3557684752959L255.78146143437075,365.45740364101954L266.89445196211096,365.4547162414195L278.00744248985114,365.3945499386726L289.1204330175913,365.27522272558235L300.2638700947226,365.11004294804025L311.3768606224628,364.93262216061805L322.489851150203,364.80175914179796L333.60284167794316,364.69172823477084L344.7462787550744,364.55592878689833L355.85926928281464,364.3950707672236L366.97225981055476,364.1997959260758L378.085250338295,363.9697468964868L389.22868741542624,363.71470123870347L400.3416779431664,363.3877962309775L411.4546684709066,362.9853581408768L422.56765899864683,362.6261519241288L433.7110960757781,362.3264353953347L444.82408660351825,362.0618408921641L455.9370771312585,361.83840553393117L467.05006765899867,361.6899171762451L478.1935047361299,361.6086471628096L489.3064952638701,361.50813174691933L500.4194857916103,361.3461730369829L511.5324763193505,361.15434321340746L522.6759133964817,360.9370450372398L533.7889039242219,360.675457181494L544.9018944519621,360.4169712710312L556.0148849797023,360.1757533324663L567.1583220568335,359.9494685682745L578.2713125845738,359.7263810472238L589.3843031123139,359.4062612469985L600.4972936400541,358.9461727176063L611.6407307171854,358.48799967516305L622.7537212449256,358.10167168798375L633.8667117726658,357.6847959723725L644.979702300406,357.2823388227003L656.1231393775372,356.848666859589L674.6346414073072,356.25865399527964L700.605548037889,355.04686072564454";
            }
            return d;
        };

        graphG
            .append('path')
            .attr("fill", "none");

        /* TASK: Method chaining */
        /* add method after .attr("d", ...) */
        const path = graphG.select("path")
            .attr("d", country => lineMaker(country.data));

        const lineAnimationDuration = 1000;

        //line path animation
        //source: https://stackoverflow.com/questions/13893127/how-to-draw-a-path-smoothly-from-start-point-to-end-point-in-d3-js
        path
            .attr("stroke-dasharray", (d, i, paths) => {
                const path = paths[i];
                const totalLength = path.getTotalLength();
                return totalLength + " " + totalLength
            })
            .attr("stroke-dashoffset", (d, i, paths) => {
                const path = paths[i];
                const totalLength = path.getTotalLength();
                return totalLength;
            })
            .transition()
            .duration(lineAnimationDuration)
            .attr("stroke-dashoffset", 0);

        const circles = graphG
            .selectAll("circle")
            .data(country => country.data);

        const newCircles = circles.enter().append("circle")
            .merge(circles)
            .attr("r", 3).attr("fill", (d, i, circles) => {
                const circle = circles[i];
                const country = circle.parentNode.__data__;
                return country.color
            })
            .attr("cx", d => scaleX(d.date))
            .attr("cy", d => scaleY(d.population))
            .style("opacity", 0);

        newCircles
            .append("title")
            .text((d, i, texts) => {
                const text = texts[i];
                const country = text.parentNode.parentNode.__data__;
                const formattedDate = timeFormatter(d.date);
                const formattedPopulation = populationFormatter(d.population);
                return `${formattedPopulation} inhabitants in ${country.label} on ${formattedDate}`;
            });

        newCircles
            .transition()
            .delay(lineAnimationDuration)
            .duration(500)
            .style("opacity", 1);
    };
};

export default createLineChart;