import * as d3 from 'd3';

//await only works inside an async function
//here the function is an anonymous one
const createPieChart = async (eventBus) => {
    /* TASK: Hello World */
    /* enter code here */

    const svgWidth = 500,
        svgHeight = 500,
        pieChartRadius = 150;

    const svg = d3.select("body")
        .append("svg")
        .attr("width", svgWidth)
        .attr("height", svgHeight);

    const svgG = svg.append("g")
        .attr("transform", "translate(" + svgWidth / 2 + "," + svgHeight / 2 + ")");

    const pie = d3.pie()
        .value(d => d.population);

    const arc = d3.arc()
        .innerRadius(0)
        .outerRadius(pieChartRadius);

    const data = await d3.json("./data/population_continents.json");

    data.forEach(d => {
        d.population = Number(d.population);
    });

    const maxPopulation = d3.max(data, d => d.population);

    const colors = d3.schemeCategory10;

    /* TASK: Scales */
    /* replace const colorFunction */
    const colorFunction = continentLabel => {
        const continentLabels = data.map(d => d.continentLabel);
        const index = continentLabels.indexOf(continentLabel);
        return colors[index];
    };

    const pieData = pie(data);

    const arcG = svgG.selectAll("g")
        .data(pieData)
        .enter().append("g")
        .attr("class", "arc");

    let transformedPath = null;

    arcG.append("path")
        .attr("d", arc)
        .style("fill", d => colorFunction(d.data.continentLabel))
        .on("click", (d, i, paths) => {
            const path = paths[i];
            const selectedPath = d3.select(path);

            if (transformedPath !== null) {
                d3.select(transformedPath)
                    .transition()
                    .duration(300)
                    .attr("transform", "translate(0, 0)");
            }

            if (transformedPath !== path) {
                //translates the pie segment from the origin in the direction
                //of the center of the pie segment
                const centroid = arc.centroid(d);
                const scaledCentroid = centroid.map(coord => coord * 0.1);

                selectedPath
                    .transition()
                    .duration(300)
                    .attr("transform", `translate(${scaledCentroid})`);

                transformedPath = path;
            } else {
                transformedPath = null;
            }

            const color = selectedPath.style("fill");
            eventBus.continentClicked(d.data.continentLabel, color);
        });

    arc.outerRadius(pieChartRadius * 2.6);

    arcG.append("text")
        .attr("transform", (d) => {
            if (d.data.continentLabel === "Oceania") {
                arc.outerRadius(pieChartRadius * 2.3);
            } else if (d.data.continentLabel === "Antarctica") {
                arc.outerRadius(pieChartRadius * 2.8);
            }

            const centroid = arc.centroid(d);

            return `translate(${centroid})`;
        })
        .style("text-anchor", "middle")
        .text( d => d.data.continentLabel)
};

export default createPieChart;