import * as d3 from 'd3';

const createSimpleChart = async () => {
    const data = await d3.json("../data/alcohol.json");

    const parsedData = Object.entries(data).map(([key, value]) => ({
        "beverage": key,
        "amount": value
    }));

    const svg = d3.select("body")
        .append("svg")
        .attr("height", 450)
        .attr("width", 900);

    const xScale = d3.scalePoint()
        .domain(["beer", "wine", "spirits"])
        .range([100, 800]);

    const rScale = d3.scaleSqrt();

    const cScale = d3.scaleOrdinal()
        .domain(["beer", "wine", "spirits"])
        .range(["yellow", "red", "blue"]);

    const symbol = d3.symbol().type(d3.symbolCircle)();
    const numberFormatter = d3.format(".2f");

    //scaling by size does not seem to work anymore with circles:
    //https://stackoverflow.com/questions/23224285/change-the-size-of-a-symbol-with-a-transition-in-d3-js
    svg.selectAll("path")
        .data(parsedData)
        .enter()
        .append("path")
        .attr("d", symbol)
        .attr("transform", (d) => `translate(${xScale(d["beverage"])},250)`)
        .style("fill", d => cScale(d["beverage"]))
        .on("click", d => alert(numberFormatter(d["amount"]) + "l"))
        .transition()
        .duration(1000)
        .attr("transform", (d) => `translate(${xScale(d["beverage"])},250)scale(${rScale(d["amount"]) * 2})`);

    const xAxis = d3.axisBottom(xScale);

    const xAxisG = svg.append("g")
        .attr("transform", "translate(0, 400)")
        .call(xAxis);

    xAxisG.select("path.domain")
        .remove();
};

export default createSimpleChart;