/* =============== MAP OBJECT =============== */

// Set the options of the map object
var map = L.map('map',{
    minZoom: 4,
    maxZoom: 7,
    center: [50.0,7.5],
    zoom: 5
    });
             
/* =============== LAYERS OBJECTS =============== */  

// Define the base layer object and add it to the map
// see http://leaflet-extras.github.io/leaflet-providers/preview/index.html

var baseLayer = new L.tileLayer.provider('OpenStreetMap.Mapnik').addTo(map);


var eu_countries = L.tileLayer.wms("http://localhost/cgi-bin/qgis_map_server/qgis_map_serv.cgi?", {
    layers: 'eu_countries',
	styles:'default',
    format: 'image/png',
    transparent: true,
    attribution: "Countries © CIA WDB II"
});



var eu_cities = L.tileLayer.wms("http://localhost/cgi-bin/qgis_map_server/qgis_map_serv.cgi?", {
    layers: 'eu_cities',
	styles:'default',
    format: 'image/png',
    transparent: true,
    attribution: "Cities © CIA WDB II"
});




/* =============== CONTROL OBJECTS =============== */

// Add the scale bar
// see http://leafletjs.com/reference.html#control-scale
L.control.scale().addTo(map);

// Layer control
// see http://leafletjs.com/reference.html#control-layers
var baseLayers = {
    'OpenStreetMap': baseLayer
};

var overlays = {
	'Countries':eu_countries,
    'Cities': eu_cities
};

L.control.layers(baseLayers, overlays).addTo(map)

 
